// stackTriangle.java
// Program wyznacza liczby trjktne, zastpujc rekurencj stosem
// Aby uruchomi program: C>java StackTriangleApp
import java.io.*;                 // for I/O
////////////////////////////////////////////////////////////////
class Params     // parametry zapisywane na stosie
   {
   public int n;
   public int returnAddress;

   public Params(int nn, int ra)
      {
      n=nn;
      returnAddress=ra;
      }
   }  // koniec klasy Params
////////////////////////////////////////////////////////////////
class StackX
   {
   private int maxSize;         // wielko tablicy StackX 
   private Params[] stackArray;
   private int top;             // wierzchoek stosu
//--------------------------------------------------------------
   public StackX(int s)         // konstruktor
      {
      maxSize = s;              // okrelamy wielko tablicy
      stackArray = new Params[maxSize];  // tworzymy tablic
      top = -1;                 // na razie tablica jest pusta
      }
//--------------------------------------------------------------
   public void push(Params p)   // umieszczenie elementu na wierzchoku stosu
      {
      stackArray[++top] = p;    // inkrementujemy indeks wierzchoka, wstawiamy element
      }
//--------------------------------------------------------------
   public Params pop()          // pobranie elementu z wierzchoka stosu
      {
      return stackArray[top--]; // pobierany element, dekrementujemy indeks wierzchoka
      }
//--------------------------------------------------------------
   public Params peek()         // odczyt elementu z wierzchoka stosu
      {                         // bez usuwania elementu
      return stackArray[top];
      }
//--------------------------------------------------------------
   }  // koniec klasy StackX
////////////////////////////////////////////////////////////////
class StackTriangleApp
   {
   static int theNumber;
   static int theAnswer;
   static StackX theStack;
   static int codePart;
   static Params theseParams;
//-------------------------------------------------------------
   public static void main(String[] args) throws IOException
      {
      System.out.print("Podaj liczbe: ");
      theNumber = getInt();
      recTriangle();
      System.out.println("Odpowiadajaca jej liczba trojkatna="+theAnswer);
      }  // koniec main()
//-------------------------------------------------------------
   public static void recTriangle()
      {
      theStack = new StackX(10000);
      codePart = 1;
      while( step() == false)  // wywoujemy step() a do zwrcenia true
         ;                     // instrukcja pusta
      }
//-------------------------------------------------------------
   public static boolean step()
      {
      switch(codePart)
         {
         case 1:                              // wywoanie pocztkowe
            theseParams = new Params(theNumber, 6);
            theStack.push(theseParams);
            codePart = 2;
            break;
         case 2:                              // "wejcie" do metody
            theseParams = theStack.peek();
            if(theseParams.n == 1)            // sprawdzenie warunku
               {
               theAnswer = 1;
               codePart = 5;   // koniec
               }
            else
               codePart = 3;   // wywoanie rekurencyjne
            break;
         case 3:                              // wywoanie metody
            Params newParams = new Params(theseParams.n - 1, 4);
            theStack.push(newParams);
            codePart = 2;  // wejcie do metody
            break;
         case 4:                              // obliczenia
            theseParams = theStack.peek();
            theAnswer = theAnswer + theseParams.n;
            codePart = 5;
            break;
         case 5:                              // wyjcie z metody
            theseParams = theStack.peek();
            codePart = theseParams.returnAddress; // (4 lub 6)
            theStack.pop();
            break;
         case 6:                              // zakoczenie dziaania metody
            return true;
         }  // koniec instrukcji switch
      return false;
      }  // koniec metody triangle
//-------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//--------------------------------------------------------------
   }  // koniec klasy StackTriangleApp
////////////////////////////////////////////////////////////////
